﻿Public Class SingleCellGrid
    Inherits Panel
    Protected Overrides Function MeasureOverride(ByVal availableSize As Size) As Size
        Dim compositeSize As New Size()

        For Each child As UIElement In Children
            child.Measure(availableSize)

            compositeSize.Width = Math.Max(compositeSize.Width, child.DesiredSize.Width)
            compositeSize.Height = Math.Max(compositeSize.Height, child.DesiredSize.Height)
        Next child

        Return compositeSize
    End Function


    Protected Overrides Function ArrangeOverride(ByVal finalSize As Size) As Size
        For Each child As UIElement In Children
            child.Arrange(New Rect(New Point(), finalSize))
        Next child

        Return MyBase.ArrangeOverride(finalSize)
    End Function
End Class